#!/usr/local/bin/python
# coding: utf-8

# Notrufalgorithmen-Proof of Concept-Pythonskript
# (c) 2019 by www,gossmann.at / www.gossmann.guru
# V0.9a
# Dieses Skript implementiert einen Proof of Concept in Python (und damit leicht für Raspberry PIs anpassbar), der einen Notruf an eine reguläre Telefonnummer absenden könnte

# - abgefragt wird die Funktion des Internets
# - es wird in frei definierbaren Intervallen um ein Lebenszeichen gebeten -> Person könnte bewusstlos sein -> sofern kein Abbruch erfolgt, wird nach einer definierbaren Zeitspanne die Rettung gerufen
# - es wird ein (emulierter) Fallsensor abgefragt und nach einer definierbaren Zeitspanne ebenfalls die Rettung gerufen, sofern nicht ein Abbruch erfolgt, d.h. die Person "nur gestürzt", aber eben nicht oder nicht ernsthaft verletzt ist, bzw. keine Rettung wünscht
# - es kann auch sofort die Rettung gerufen werden, wenn das entsprechende Kommando entdeckt wird

# die Steuerung durch Kommandos erfolgt über eine Kommandodatei (instruction.txt)

# derzeit werden darin folgende Kommandos unterstützt, die als Klartext vorliegen müssen, wobei es unabhängig davon ist, "wer diese Datei erstellt", also auch z.B. ein Sprachassistent durch Zuruf

# "alles ok" -> keine Reaktion
# "Abbruch" -> Alarmstatus wird aufgehoben, Rettung wird nicht alarmiert (derzeit bei Fallsensor, bzw. definiertem Checkintervall auf Lebenszeichen)
# "Rettung" -> Rettung wird gerufen, egal was passiert ist

# "Fall" -> Sturzsensor hat ausgelöst und Alarmstatus wird gesetzt -> Zeitintervall für Abbruch wird in Gang gesetzt: bei Abbruch keine Reaktion, bei Timeout (=keine Reaktion) wird Rettung gerufen
# Sensoren generell könnten z.B. auf Raspberry-PIs durch GPIO-PIN-Abfragen reagieren und die Kommandodatei entsprechend "schreiben"


# zwecks Zeitberechnung des Intervalls Datumsfunktionen importieren:
from datetime import datetime

# API für Rettung rufen in einer Rettungsleitstelle (hier beim Provider Twilio - kann aber auch jeder andere beliebige Anbieter sein, der eine Internet zu Telefonverbindung aufbaut
from twilio.rest import Client

# checkurl importieren zwecks Ping-Test für die grundsätzliche Funktion der Internetverbindung
from urllib.request import urlopen

# zwecks Sprachausgabe unter Windows, die systemspezifische Sprachausgabe importieren, auf Raspberry-PIs könnte dies durch eine Google-API erfolgen
import win32com.client

# ************************************************************************
# für Raspberry-PI-Sprachausgabe müsste der Import folgendermaßen erfolgen
# ************************************************************************

# auf der Kommandozeile:
# ________________

# sudo apt-get install espeak
# sudo apt-get install espeak python-espeak

# in Python:
# _______

# from espeak import espeak
# espeak.set_voice("de")
# espeak.synth("Was der Pi sagen soll")

# wenn sys.exit gewünscht ist bei Fehler, wird hier aber (noch) nicht gebraucht
# import sys 

# D. Funktion schreibt ein Kommando in die Kommandodatei - der Sinn im Kontrolllogikskript ist, dass nach Abbarbeitung eines Kommandos die Datei wieder "gesäubert" wird, indem "alles ok" reingeschrieben wird, sonst würde das Kommando abermals abgearbeitet werden
def create_commandfile(S_command):
	# Kommandodatei öffnen und gewünschtes Kommando eintragen - für das Notrufkontrolllogikskript natürlich zuerst einmal "alles ok"
	try:
		
		file = open(S_instruction_file,"w") 
		file.write(S_command) 
		file.close()
		return True
	
	# im Fehlerfall melden
	except IOError:
		
		# per Text
		print ("Fehler beim Anlegen der Kommandodatei - create_commandfile function")
		# und Sprache
		speaker = win32com.client.Dispatch("SAPI.SpVoice")
		speaker.Speak("Lieber "+S_target_person_name+" Fehler beim Auslesen der Kommandodatei. Liebe"+S_target_person_name+" bitte rufe vorsorglich einen Techniker.")
		# ABER KEIN SYS.EXIT!!!!!!!!!!!!! - vielleicht kommt´s ja wieder unter Kontrolle - ist ein Notrufsystem, das online sein muss und nicht abgebrochen werden darf deswegen
		# sys.exit(I_IOError)			

# d. Funktion testet, ob eine Internetverbindung zu einem bestimmten Server besteht
def F_test_internetconnection():

	try:
		
		# Zielserver erreichbar?
		response=urlopen(S_TestURL, timeout=10)
		# ja - alles ok melden - KANN AUCH WEGGELASSEN WERDEN, UM NICHT ZU NERVEN, WENN ALLES EH OK IST, WEIL BESSER NUR ALARM GEMELDET WERDEN SOLL
		print ("Status der Internetverbindung: funktioniert")
		speaker = win32com.client.Dispatch("SAPI.SpVoice")
		speaker.Speak(S_online_TXT)
		return True
		
	except:
		
		print ("Status der Internetverbindung: NICHT funktionsfähig! Bitte dringend Servicetechniker verständigen!")
		# nein -> Exception geworfen, dann Alarm melden
		speaker = win32com.client.Dispatch("SAPI.SpVoice")
		speaker.Speak(S_offline_TXT)
		return False

# d. Funktion errechnet aus zwei Zeiten die Differenz in Sekunden -> dient zur Abfrgae von abgelaufenen Testintervallen
def F_time_difference(time_start, time_end):
	
	# source: https://codereview.stackexchange.com/questions/127563/calculate-difference-between-two-times
	# Args:
	# time_start: the time to use as a starting point
	# time_end: the time to use as an end point
	# Returns:
	# the difference between time_start and time_end
	# Start- und Endzeit in richtiges Format trimmen
	start = datetime.strptime(time_start, "%H%M%S")
	end = datetime.strptime(time_end, "%H%M%S")
	# verstrichene Zeit zwischen Beiden ermitteln
	difference = end - start
	# die ermittelten, verstrichene Sekunden an Aufrufer liefern
	return (difference.total_seconds())

# *****************
# Hauptprogramm
# *****************

# Kommando-Dateivariablen:

# wie die Kommandodatei heißen soll:
S_instruction_file = "instruction.txt"

# die derzeit unterstützten Kommandos:

S_all_clear = "alles ok"
S_ambulance = "Rettung"
S_cancel = "Abbruch"
S_fall = "Fall"

# Fehlercodes:

I_IOError=1

# standardm. von "ok" ausgehen
S_instruction="alles ok"

# zu checkenden Server zwecks Internetverbindungstest -> sollte der Provider der Internet zu Telefon-Funktion sein (hier wird der ORF verwendet, dass der Provider bei den allfällig kurzen Demotestintervallen nicht von "Hackerangriff" ausgeht und die IP sperrt)
# S_TestURL="https://www.twilio.com/"
S_TestURL="https://www.orf.at/"

# die erhaltenen API-Aufrufdaten von twilio.com - wo man Anrufe per Skript initieren kann: xxx HIER MÜSSEN DIESE BEIDEN INDIVIDUELL ANGEPASST WERDEN xxx
#account_sid = 'bitte hier Ihre Account-SID eintragen'
#auth_token = 'bitte hier Ihr Account-Token eintragen'

client = Client(account_sid, auth_token)

# Sprachausgabetexte des Systems (eigentlich könnte man für alle eine Variable verwenden, um internationl zu sein - würde aber den Quellcode höchst unleserlich machen):

# Personalisierung erfolgt hier, indem hier der Name des Patienten eingegeben wird XXX HIER KANN EINE PERSONALISIERUNG FÜR DIE JEWEILIG PERSON VORGENOMMEN WERDEN -> das "r" steht für das "r" von LiebeR, da es auch Damen gibt, dann bitte weglassen XXX
S_target_person_name="r Christian"

# auch die Internet-Status-Meldungen personalisieren
S_offline_TXT="Achtung, lieber Christian, deine Internetverbindung wurde unterbrochen. Bitte rufe einen Techniker."
# exemplarisch für Englisch, das deutsche wird aber mit lustigem englischem Akzent ausgegeben
S_online_TXT="Lieber Christian, alles in Ordnung, deine Internetverbindung funktioniert."

# now = datetime.now().strftime('%Y-%m-%d %H:%M:%S') gäbe es auch
S_current_starttime_internetcheck = datetime.now().strftime('%H%M%S')
S_current_starttime_lifecheck = datetime.now().strftime('%H%M%S')
# aktuelle Uhrzeit holen zwecks Internetfunktionscheck, Lebenscheck und Intervall für Abfrage der Kommandodatei
S_current_starttime_instructionfilecheck = datetime.now().strftime('%H%M%S')

# solange Lebenscheckintervall noch nicht aufgerufen wurde, wird das sonst nicht gesetzt, was aber durch den Fallsensor passieren kann würde -> die Zeit ab der Alarm ausgelöst wurde und die als Basis für die Zeitspannenverstreichung des Abbruchintervalls dient
# in der Alarmabfrage käme es dann zu Fehlverhalten, wenn das noch nicht initialisiert wäre, daher auch hier die Regel: alle Variablen eines Programmes zuerst einmal initialisieren mit Defaultwerten
S_current_starttime_alertcancelcheck = datetime.now().strftime('%H%M%S')

# hier die gewünschten Checkintervallzeiten je nach Wunsch eintragen - Werte sind in Sekunden -> alle angegebenen Sekunden erfolgt dann ein entsprechender Check - ACHTUNG bei Überschneidungen -> dies kann dann zur verspäteten Abbarbeitung führen (Check für Check)

# standardnm. sehr konservative Werte wählen - XXX BITTE MIT PERSON ABSPRECHEN, OB DIE SO PASSE XXX allfällig könnte man diese Werte auch durch ein GUI-Interface durch die Person einstellen lassen -> die GUI müsste dazu das Skript modifizieren an dieser Stelle

# alle 1/4 Stunde (900 Sekunden)
I_internet_check_intervall_seconds = 600

# Intervall, wie oft getestet wird, ob Zielperson noch lebt, bzw. ok ist -> 86400 Sekunden sind 1 Tag, also täglich 1x
I_life_check_intervall_seconds =300

# Zeit, die die Zielperson Zeit hat, einen Alarmstatus, der zu einem Notruf führt, abzubrechen (String fuer Sprachausgabefunktion, Integer fuer programmtechnischen Intervallcheck - könnte man auch mit einer Konvertierroutine machen...) - hier 1 Minute
S_cancel_lifecheckintervall_time = "30"
I_cancel_intervall = 30

# alle 5 Sekunden auf ein vorliegendes Kommando prüfen -> da es sich um die Kommandodatei handelt, sollte dieses Intervall auch recht kurz bleiben, zu lange Intervalle würden hier zu unnötigen Verzögerungen führen
I_commandfilecheck_intervall=5

# Kontrolllogikvariablen setzen -> standardm. von keinem Alarmstatus ausgehen überall
B_alertstatus=False 
B_immediate_ambulance_wish=False
B_ambulance_called=False
B_check_lifeecho=False

# Initialisierend zuerst eine Kommandodatei mit keinem Alarm, bzw. dem Wunsch nach der Rettung anlegen: "alles ok"
create_commandfile(S_all_clear)

try:
	# Dauerereignisschleife 
	while True:

#		xxx hier sind Debug-Ausgaben vom Test, die man bei Bedarf hier erweitern und / oder wieder scharfschalten kann, indem man sie einkommentiert (je nach Wunsch der zu überwachenden Variable)

#		print ("I_cancel_intervall: "+str(I_cancel_intervall))
#		print ("I_life_check_intervall_seconds: "+str(I_life_check_intervall_seconds))
#		print ("I_commandfilecheck_intervall: "+str(I_commandfilecheck_intervall))
#		print ("B_ambulance_called: "+str(B_ambulance_called))
#		print ("B_immediate_ambulance_wish: "+str(B_immediate_ambulance_wish))
#		print ("B_alertstatus: "+str(B_alertstatus))
#		print ("S_current_starttime_internetcheck: "+S_current_starttime_internetcheck)
#		print ("S_current_starttime_lifecheck: "+S_current_starttime_lifecheck)
#		print ("S_current_starttime_instructionfilecheck: "+S_current_starttime_instructionfilecheck)
#		print ("S_current_starttime_alertcancelcheck: "+S_current_starttime_alertcancelcheck)
#		print ("S_instruction: "+S_instruction)
		
		# immer die akt. Systemzeit holen, da diese Basis für die Intervallchecks ist
		S_intervall_checktime = datetime.now().strftime('%H%M%S')
		
		# xxx Debug-Code xxx Zeitausgabe, bzw. damit man am Bildschirm die Zeit verstreichen sieht
		# print ("aktuelle Zeit: "+S_intervall_checktime)
		
		# hier je nach gewünschtem Intervall prüfen, ob die Internetverbindung noch funktioniert
		# ist das Wunschintervall dafür schon verstrichen?
		if F_time_difference(S_current_starttime_internetcheck, S_intervall_checktime)> I_internet_check_intervall_seconds:
			
			# ja, zuerst wird dann die neue Vergleichsstartzeit für den nächsten Test die jetztige akt. Uhrzeit, um ein neuerliches verstrichenes Intervall zu testen (sonst bliebe das jetztige ja verstrichen und es würde ständig getestet werden ab jetzt)
			S_current_starttime_internetcheck=S_intervall_checktime
			# eigentliche Internetverbindung testen
			F_test_internetconnection()

		# hier je nach Intervall testen, ob Zielperson noch lebt, d.h. also ob sie überhaupt noch ein Lebenszeichen von sich geben kann, bzw. auch, wenn der Fallsensor angeschlagen hat
		# akt. Systemzeit mit Startzeit vom Skript vergleichen (seit dann läuft es ja), ob das Wunschintervall schon verstrichen ist
		if (F_time_difference(S_current_starttime_lifecheck, S_intervall_checktime)> I_life_check_intervall_seconds and B_alertstatus==False) or (S_instruction==S_fall and B_alertstatus==False):
			
			# ja, zuerst wird dann die neue Vergleichsstartzeit für den nächsten Test die jetztige akt. Uhrzeit, um ein neuerliches verstrichenes Intervall zu testen (sonst bliebe das jetztige ja verstrichen und es würde ständig getestet werden ab jetzt)
			S_current_starttime_lifecheck=S_intervall_checktime
			# Alarmzeit setzen (ab dieser Zeit wird Zeitspanne verglichen, in der noch ein Abbruch erfolgen kann -> anderenfalls wird Rettung geschickt) - solange Alarmstatus noch nicht aktiv ist, sonst wird die Zeit neu gesetzt und der Intervallcehck zum Abbruch funktioniert nicht
			if B_alertstatus==False:
				S_current_starttime_alertcancelcheck=S_intervall_checktime
			# jetzt auch Alarmstatus setzen und Vermerken, dass dies der Lebensecho-Check ist
			B_alertstatus=True
			B_check_lifeecho=True
			# eigentliche Testfrage, ob Zielperson noch lebt, bzw. in Ordnung ist, indem zuerst einmal freundlich um ein Lebenszeichen ersucht wird
			speaker = win32com.client.Dispatch("SAPI.SpVoice")
			speaker.Speak("Liebe"+S_target_person_name+"wir sind sehr besorgt um dich. Wenn es dir gut geht, informiere uns bitte innerhalb von "+S_cancel_lifecheckintervall_time
+" Sekunden. Sonst schicken wir dir vorsorglich die Rettung.")

		# hier je nach Intervall testen, ob ein Kommando in der Kommando-Datei vorliegt
		if F_time_difference(S_current_starttime_instructionfilecheck, S_intervall_checktime)> I_commandfilecheck_intervall:
			
			# ja, zuerst wird dann die neue Vergleichsstartzeit für den nächsten Test die jetztige akt. Uhrzeit, um ein neuerliches verstrichenes Intervall zu testen (sonst bliebe das jetztige ja verstrichen und es würde ständig getestet werden ab jetzt)
			S_current_starttime_instructionfilecheck=S_intervall_checktime
			# Kommandodatei einlesen
			try:
				
				# Kommandodatei öffnen und darin enthaltenes Kommando auslesen
				file = open(S_instruction_file,"r") 
				for line in file: 
					S_instruction=line
					print ("Kommandodateiinhalt: "+S_instruction)
				file.close()
			
			# im Fehlerfall melden
			except IOError:
				
				# per Text
				print ("Fehler beim Auslesen der Kommandodatei - main module")
				# und Sprache
				speaker = win32com.client.Dispatch("SAPI.SpVoice")
				speaker.Speak("Lieber "+S_target_person_name+" Fehler beim Auslesen der Kommandodatei. Liebe"+S_target_person_name+" bitte rufe einen Techniker.")
				# ABER KEIN SYS.EXIT!!!!!!!!!!!!! - vielleicht kommt´s ja wieder unter Kontrolle - ist ein Notrufsystem, das online sein muss und nicht abgebrochen werden darf deswegen
				# sys.exit(I_IOError)			

		# hier werden die Kommandos aus der Kommandodatei ausgewerten, was jetzt zu geschehen hat

		# soll Alarmstatus / Notruf-Abbruch erfolgen?
		if S_instruction==S_cancel:
			
			# ja -> vermerken
			B_alertstatus=False
			speaker = win32com.client.Dispatch("SAPI.SpVoice")
			speaker.Speak("Liebe"+S_target_person_name+", wir sind sehr erleichtert, dass du die Rettung nicht brauchst und den Notruf abgebrochen hast.")
			# Kommandodatei wieder zurücksetzen, damit das Kommando nicht erneut abgearbeitet wird
			create_commandfile(S_all_clear)

		# soll Rettung sofort gerufen werden, unabhängig von irgendeinem Sensor oder Intervall?
		if S_instruction==S_ambulance:
			
			# ja -> vermerken, dass sofort die Rettung gerufen werden soll
			B_immediate_ambulance_wish=True
			B_alertstatus=True
			# Kommandodatei wieder zurücksetzen, damit das Kommando nicht erneut abgearbeitet wird
			create_commandfile(S_all_clear)
	
		# ist (wieder) alles ok, bzw. auch nach einem Rettungsruf wieder den Status der Kontrolllogikvariablen reinitialisieren (sonst müsste das Skript durch die Rettung neu gestartet werden),
		# sofern nicht gerade der Lebensechecheck läuft, sonst würde dessen Intervall-Alarmstatus hier zurückgesetzt werden
		if S_instruction==S_all_clear and B_check_lifeecho==False:
	
			B_alertstatus=False 
			B_immediate_ambulance_wish=False
			B_ambulance_called=False	
			S_current_starttime_alertcancelcheck = datetime.now().strftime('%H%M%S')

		# hier erfolgt die Alarmstatus, bzw. Abbruchauswertung und im Ernstfall der Rettungsnotruf durch den jeweiligen Internet zu Telefonanbieter:

		# ist nun tatsächlich irgendetwas vorgefallen, das vielleicht einen automatischen oder sofortigen Rettungseinsatz erfordert, d.h der Alarmstatus wurde gesetzt und die Rettung wurde bisher noch nicht gerufen?
		if B_alertstatus==True and B_ambulance_called==False:
			
			# ja -> noch testetn, ob die Abbruchzeitspanne schon verstrichen, wo ansonsten automatisch die Rettung gerufen werden soll -> Person reagiert nicht, bzw. ist bewusstlos?
			if F_time_difference(S_current_starttime_alertcancelcheck, S_intervall_checktime)>I_cancel_intervall:
				
				
				# S_current_starttime_alertcancelcheck=S_intervall_checktime
				
				# ja -> Rettung rufen
				speaker = win32com.client.Dispatch("SAPI.SpVoice")
				speaker.Speak("Liebe"+S_target_person_name+" du hast nicht reagiert, wir schicken dir daher jetzt die Rettung.")
				# hier Ihre Nummern für die Rettung eingeben anstatt "[TEL]"
				call = client.calls.create(url='http://demo.twilio.com/docs/voice.xml', to='+[TEL]', from_='+[TEL]')
				print(call.sid)
				B_ambulance_called=True
				print ("Die Rettung wurde vorsorglich gerufen.")
				# Kommandodatei wieder zurücksetzen und Kontrolllogikvariablen reinitialisieren, Rettung wurde ja gerufen
				create_commandfile(S_all_clear)
				B_alertstatus=False 
				B_immediate_ambulance_wish=False
				B_ambulance_called=False
				B_check_lifeecho=False
				S_current_starttime_alertcancelcheck = datetime.now().strftime('%H%M%S')
			
			# unabhängig von Abbruchzeitintervall noch prüfen, ob ein Sofortrettungswunsch vorliegt?
			if B_immediate_ambulance_wish==True:
				
				# ist dem tatsächlich so -> sofort die Rettung rufen
				speaker = win32com.client.Dispatch("SAPI.SpVoice")
				speaker.Speak("Liebe"+S_target_person_name+" wir alarmieren dir sofort die Rettung.")
				
				# hier Ihre Nummern für die Rettung eingeben anstatt "[TEL]"
				call = client.calls.create(url='http://demo.twilio.com/docs/voice.xml', to='+[TEL]', from_='+[TEL]')
				print(call.sid)
				B_ambulance_called=True
				print ("Die Rettung wurde wunschgemäß sofort gerufen.")
				# Kommandodatei wieder zurücksetzen und Kontrolllogikvariablen reinitialisieren, Rettung wurde ja gerufen
				create_commandfile(S_all_clear)
				B_alertstatus=False 
				B_immediate_ambulance_wish=False
				B_ambulance_called=False
				B_check_lifeecho=False
				S_current_starttime_alertcancelcheck = datetime.now().strftime('%H%M%S')

# Dauerschleife bis durch Tastatur abgebrpochen wird
except KeyboardInterrupt:
	# reguläres Programmende
	quit()




